%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN the script IN SECTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
%% extract proper thresholds for the cell boundary and Golgi from the movie
names = 'pos4';
name = [names,'.tif'];
% find the values for tg and tc
frame = 5;
I=imread(name,frame);
segment_cell(I)
numPoints=100;
%% put a mask on the Golgi and extract the flow data
infoi = imfinfo(name);
% get the first boundary
I=imread(name,1);
f1 = fspecial('Gaussian', 5, 5/3);
f2 = fspecial('Gaussian', 5, 5/2);
df = f1-2.*f2;
Im = conv2(double(I), df, 'same');
Im = imcomplement(Im);

Im = Im./max(max(Im));
th = graythresh(Im)+tc;
bw1 = im2bw(Im,th);
bw1 = imclearborder(bw1);
bw1 = bwareaopen(bw1,5000);
se = strel('disk',10);
bw1 = imclose(bw1,se);
bw1 = imfill(bw1,'holes');
bwold=bw1;

boundary=bwboundaries(bw1);
boundary=boundary{1};
boundaryLength=size(boundary,1)-1;
indexCol=[0:(numPoints/boundaryLength):numPoints];
previousEdgeCoors(:,1)=interp1(indexCol,boundary(:,1),0.5:numPoints);
previousEdgeCoors(:,2)=interp1(indexCol,boundary(:,2),0.5:numPoints);
for frame=1:length(infoi)-1
%     if frame==19
%         tc = -0.068199980000000;
%         tg = 0.272800020000000;
%     end
    I=imread(name,frame+1);
    %     bw1 =  im2bw(I,tc);
    %     bw1 = imclearborder(bw1);
    %     bw1 = bwareaopen(bw1,5000);
    %     se = strel('disk',10);
    %     bw1 = imclose(bw1,se);
    %     bw1 = imfill(bw1,'holes');
    
    f1 = fspecial('Gaussian', 5, 5/3);
    f2 = fspecial('Gaussian', 5, 5/2);
    df = f1-2.*f2;
    Im = conv2(double(I), df, 'same');
    Im = imcomplement(Im);
    
    Im = Im./max(max(Im));
    th = graythresh(Im)+tc;
    bw1 = im2bw(Im,th);
    bw1 = imclearborder(bw1);
    bw1 = bwareaopen(bw1,5000);
    se = strel('disk',10);
    bw1 = imclose(bw1,se);
    bw1 = imfill(bw1,'holes');
    
    boundary=bwboundaries(bw1);
    boundary=boundary{1};
    boundaryLength=size(boundary,1)-1;
    indexCol=[0:(numPoints/boundaryLength):numPoints];
    edgeCoors(:,1)=interp1(indexCol,boundary(:,1),0.5:numPoints);
    edgeCoors(:,2)=interp1(indexCol,boundary(:,2),0.5:numPoints);
    
    distSum=zeros(numPoints-1,1);
    distSum(1) = sum(sum((edgeCoors-previousEdgeCoors).^2));
    for i=1:(numPoints-1)
        temp=matrixCircularlyPermuteRows(edgeCoors,i);
        distSum(i)=sum(sum((temp-previousEdgeCoors).^2));
        %             clf;
        %              plot(temp(:,1),temp(:,2),'ob')
        %                 hold on
        %                 plot(temp(1,1),temp(1,2),'or')
        %                 drawnow
    end
    %figure(4)
    %plot(distSum)
    [~,phaseVal]=min(distSum);
    edgeCoors=matrixCircularlyPermuteRows(edgeCoors,phaseVal);
    
    % record morphodynamics
    [a,b] = findnorm(previousEdgeCoors);
    u = zeros(numPoints,1);
    v = zeros(numPoints,1);
    for i=1:numPoints
        norm = sqrt((edgeCoors(i,1)-previousEdgeCoors(i,1))^2+(edgeCoors(i,2)-previousEdgeCoors(i,2))^2);
        if isnan(a(i))
            dproj = abs(edgeCoors(i,2)-previousEdgeCoors(i,2));
        else
            dproj = abs(a(i)*edgeCoors(i,1)-edgeCoors(i,2)+b(i))/sqrt(a(i)^2+1);
        end
        if dproj>norm
            dnorm = 0;
        else
            dnorm = sqrt(norm^2-dproj^2);
        end
        signm = bwold(round(edgeCoors(i,1)),round(edgeCoors(i,2)));
        if signm==0
            signm = -1;
        end
        MD(i,frame) = -signm*norm;
        MDn(i,frame) = -signm*dnorm;
        
        if isnan(a(i))
            u(i) = edgeCoors(i,1);
            v(i) = edgeCoors(i,2);
        else
            u(i) = ((edgeCoors(i,2)+1/a(i)*edgeCoors(i,1))-b(i))/(a(i)+1/a(i));
            v(i) = a(i)*u(i)+b(i);
        end
        
        %u(i) = u(i)*MDn(i,k);
        %v(i) = v(i)*MDn(i,k);
    end
    
    th = graythresh(Im)+tg;
    bw2 =  im2bw(Im,th);
    se = strel('disk',10);
    bw2 = imerode(bw2,se);
    bw2 = imclose(bw2,se);
    bw2 = imfill(bw2,'holes');
    bw2=bwareafilt(bw2,1);
    se = strel('disk',10);
    s = regionprops(bw2,'centroid');
    x = s.Centroid(1);
    y = s.Centroid(2);
    bw2 = imdilate(bw2,se);
    
    ind=find(bw2==1);
    I(ind)=0;
    %imshowpair(I,bw1)
    maxI = max(max(I));
    imshow(I,[5000 maxI*0.8])
    %imshow(I,[])
    hold on
    plot( edgeCoors(:,2), edgeCoors(:,1),'ow')
    M(frame) = getframe;
    hold on
    for k=1:numPoints
        plot([edgeCoors(k,2) x],[edgeCoors(k,1) y],'c');
        prof = improfile(I,[edgeCoors(k,2) x],[edgeCoors(k,1) y]);
        res(k,frame) = mean(nonzeros(prof));
    end
    drawnow
    
    previousEdgeCoors = edgeCoors;
    bwold=bw1;
end
myVideo = VideoWriter([names,'.avi'], 'Uncompressed AVI');
myVideo.FrameRate = 10;  % Default 30
open(myVideo);
writeVideo(myVideo, M);
close(myVideo);
%% show the morphodynamic and trafficking maps
f1 = fspecial('Gaussian',5,1);
SMs= imfilter(res,f1,'replicate');
% ind =isnan(SMs(:));
% ind = find(ind==1);
% SMs(ind)=mean(mean(SMs,'omitnan'),'omitnan');
MDns= imfilter(MDn,f1,'replicate');
figure;
imshow(SMs,[])
colormap('jet')
figure;
imshow(MDns,[])
colormap('jet')
%% cross-correlation analysis

for i=1:100
    S = SMs(i,:)-mean(SMs(i,:));
    S = S./max(S); 
    M = MDns(i,:)-mean(MDns(i,:));
    M = M./max(M);
    [r(i,:),lag] = xcov(S,M);
    r(i,:)=r(i,:)./(sqrt(var(S))*sqrt(var(M)))./100;
end
rm = mean(r,1);
figure
plot(lag,rm)
%% for saving
save([names,'.mat'],'res','SMs','MDn','MDns','r','rm','lag');




